<?php

namespace Widget\StockBundle\Tests\EventListener;


use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Event\ProductStyleStockUpdateSingleEvent;
use Widget\StockBundle\EventListener\ProductStyleStockUpdateSingleEventListener;
use Widget\StockBundle\Model\StockStyle;
use Widget\StockBundle\Model\StockStyleLog;
use Widget\StockBundle\Model\StockStyleLogQuery;
use Widget\StockBundle\Model\StockStyleQuery;

class ProductStyleStockUpdateSingleEventListenerTest extends BaseWebTestCase
{
    public function test_updateStyleStock()
    {
        // arrange
        $siteUser = SiteUserQuery::create()->findOne();
        $product = ProductQuery::create()->orderById(\Criteria::DESC)->findOne();
        $newProductId = "{$product->getId()}-5566";
        $event = new ProductStyleStockUpdateSingleEvent($product->getId(), $newProductId);

        // 寫幾筆假庫存&log進去
        $styleStock = new StockStyle();
        $styleStock->setId($product->getId());
        $styleStock->setProductId($product->getId());
        $styleStock->setQuantity(100);
        $styleStock->save();

        $styleStockLog = new StockStyleLog();
        $styleStockLog->setSiteUser($siteUser);
        $styleStockLog->setStockStyle($styleStock);
        $styleStockLog->setQuantity(999);
        $styleStockLog->save();

        // act
        $productStyleStockDeleteListener = new ProductStyleStockUpdateSingleEventListener();
        $productStyleStockDeleteListener->updateStyleStock($event);

        // assert
        $newStyleStock = StockStyleQuery::create()->findPk($newProductId);
        $newStyleStockLog = StockStyleLogQuery::create()->filterByStyleId($newProductId)->find();

        $this->assertNotNull($newStyleStock);
        $this->assertEquals($newProductId, $newStyleStock->getId());
        $this->assertNotNull($newStyleStockLog);
        $this->assertCount(1, $newStyleStockLog);

        $newStyleStockLog->delete();
        $newStyleStock->delete();

        
               
    }
}