<?php

namespace Widget\StockBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\ProductStyleBundle\Event\ProductStyleStockMigrateEvent;
use Widget\StockBundle\EventListener\ProductStyleStockMigrateListener;
use Widget\StockBundle\Model\StockQuery;
use Widget\StockBundle\Model\StockStyleQuery;

class ProductStyleStockMigrateListenerTest extends BaseWebTestCase
{
    public function test_migrateStock()
    {
        // arrange
        // 沒設關聯 可以隨便寫值
        $styleMixKey = '1-2-3';
        $productId = 1;
        $event = new ProductStyleStockMigrateEvent();
        $event->addProductIds($productId);
        $event->addProductStyleMixIds($styleMixKey);
        $stock = StockQuery::create()->findPk($productId);
        
        // act
        $productStyleStockMigrateListener = new ProductStyleStockMigrateListener();
        $productStyleStockMigrateListener->migrateStock($event);

        // assert
        $stockStyle = StockStyleQuery::create()->findPk($styleMixKey);
        $this->assertEquals($styleMixKey, $stockStyle->getId());
        $this->assertEquals($productId, $stockStyle->getProductId());
        $this->assertEquals($stock->getQuantity(), $stockStyle->getQuantity());
        
        $stockStyle->delete();
    }
}