<?php

namespace Widget\StockBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Symfony\Component\HttpFoundation\Response;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Model\ProductStyleMixQuery;
use Widget\StockBundle\Model\StockStyle;
use Widget\StockBundle\Service\InsertStockLogService;

class StockStyleBatchQuantityControllerTest extends BackendWebTestCase
{
    public function test_getBatchQuantityAction()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stockStyle = $this->createStockStyle();

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_stock_backendapi_stockstylebatchquantity_getbatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayNotHasKey('data', $responseArray);
        $this->assertArrayNotHasKey('pager', $responseArray);
        $this->assertArrayHasKey('id', $responseArray[0]);
        $this->assertArrayHasKey('product_name', $responseArray[0]);
        $this->assertArrayHasKey('product_style_name', $responseArray[0]);
        $this->assertArrayHasKey('quantity', $responseArray[0]);

        $con->rollBack();
    }

    public function test_updateBatchQuantityAction_bad_params_format_no_id()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stockStyle = $this->createStockStyle();
        $params = array(
            array(
                'quantity' => '99999'
            )
        );

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockstylebatchquantity_updatebatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        // assert
        $con->rollBack();
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_updateBatchQuantityAction_bad_params_format_no_quantity()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stockStyle = $this->createStockStyle();
        $params = array(
            array(
                'id' => $stockStyle->getId(),
            )
        );

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockstylebatchquantity_updatebatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        // assert
        $con->rollBack();
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_updateBatchQuantityAction_bad_format()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stockStyle = $this->createStockStyle();
        $params = array(
            array(
                'id' => $stockStyle->getId(),
                'quantity' => '99999'
            ),
            array(
                'id' => 111,
                'quantity' => '-1'
            ),
            array(
                'id' => 111,
                'quantity' => '999'
            ),
            array(
                'id' => 111,
                'quantity' => 'aaaa'
            )
        );

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockstylebatchquantity_updatebatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $con->rollBack();
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
        $this->assertCount(2, $responseArray);
        $this->assertArrayHasKey('index', $responseArray[0]);
        $this->assertArrayHasKey('error', $responseArray[0]);
    }

    public function test_updateBatchQuantityAction_ok()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $stockStyle = $this->createStockStyle();
        $stockStyleId = $stockStyle->getId();
        $stockStyleQuantity = $stockStyle->getQuantity();
        $insertStockLogService = $this->getMockBuilder(InsertStockLogService::class)
            ->disableOriginalConstructor()
            ->setMethods(array('insertStyleLog'))
            ->getMock();
        $insertStockLogService
            ->expects($this->once())
            ->method('insertStyleLog')
            ->willReturnCallback(function($id, $quantity) use($stockStyleId, $stockStyleQuantity){
                $this->assertEquals($stockStyleId, $id);
                $this->assertEquals($stockStyleQuantity, $quantity);
            });
        $this->client->getContainer()->set('widget.stock_bundle.service.insert_stock_service', $insertStockLogService);

        $params = array(
            array(
                'id' => $stockStyle->getId(),
                'quantity' => '99999'
            )
        );

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockstylebatchquantity_updatebatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        // assert
        $stockStyle->reload(true);
        $this->assertTrue($response->isOk());

        $con->rollBack();
    }

    protected function createStockStyle()
    {
        $stockStyle = new StockStyle();
        $stockStyle->setId(ProductStyleMixQuery::create()->findOne()->getId());
        $stockStyle->setProductId(ProductQuery::create()->findOne()->getId());
        $stockStyle->setQuantity(5);
        $stockStyle->save();
        return $stockStyle;
    }    
}