<?php

namespace Widget\StockBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Symfony\Component\HttpFoundation\Response;
use Widget\StockBundle\Model\StockQuery;
use Widget\StockBundle\Service\InsertStockLogService;

class StockBatchQuantityControllerTest extends BackendWebTestCase
{
    public function test_getBatchQuantityAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_stock_backendapi_stockbatchquantity_getbatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayNotHasKey('data', $responseArray);
        $this->assertArrayNotHasKey('pager', $responseArray);
        $this->assertArrayHasKey('id', $responseArray[0]);
        $this->assertArrayHasKey('product', $responseArray[0]);
        $this->assertArrayHasKey('quantity', $responseArray[0]);

    }

    public function test_updateBatchQuantityAction_bad_params_format_no_id()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stock = StockQuery::create()->findOne();
        $params = array(
            array(
                'quantity' => '99999'
            )
        );

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockbatchquantity_updatebatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        // assert
        $con->rollBack();
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_updateBatchQuantityAction_bad_params_format_no_quantity()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stock = StockQuery::create()->findOne();
        $params = array(
            array(
                'id' => $stock->getId(),
            )
        );

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockbatchquantity_updatebatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        // assert
        $con->rollBack();
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_updateBatchQuantityAction_bad_format()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stock = StockQuery::create()->findOne();
        $params = array(
            array(
                'id' => $stock->getId(),
                'quantity' => '99999'
            ),
            array(
                'id' => 111,
                'quantity' => '-1'
            ),
            array(
                'id' => 111,
                'quantity' => '999'
            ),
            array(
                'id' => 111,
                'quantity' => 'aaaa'
            )
        );

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockbatchquantity_updatebatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $con->rollBack();
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
        $this->assertCount(2, $responseArray);
        $this->assertArrayHasKey('index', $responseArray[0]);
        $this->assertArrayHasKey('error', $responseArray[0]);
    }

    public function test_updateBatchQuantityAction_ok()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $stock = StockQuery::create()->findOne();

        $stockId = $stock->getId();
        $stockQuantity = $stock->getQuantity();
        $insertStockLogService = $this->getMockBuilder(InsertStockLogService::class)
            ->disableOriginalConstructor()
            ->setMethods(array('insertLog'))
            ->getMock();
        $insertStockLogService
            ->expects($this->once())
            ->method('insertLog')
            ->willReturnCallback(function($id, $quantity) use($stockId, $stockQuantity){
                $this->assertEquals($stockId, $id);
                $this->assertEquals($stockQuantity, $quantity);
            });
        $this->client->getContainer()->set('widget.stock_bundle.service.insert_stock_service', $insertStockLogService);

        $params = array(
            array(
                'id' => $stock->getId(),
                'quantity' => '99999'
            )
        );

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockbatchquantity_updatebatchquantity'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertTrue($response->isOk());

        $con->rollBack();
    }
}