<?php

namespace Widget\StockBundle\Service;

use Backend\BaseBundle\Model\SiteUser;
use JMS\DiExtraBundle\Annotation as DI;
use Widget\StockBundle\Model\Stock;
use Widget\StockBundle\Model\StockLog;
use Widget\StockBundle\Model\StockQuery;
use Widget\StockBundle\Model\StockStyle;
use Widget\StockBundle\Model\StockStyleLog;
use Widget\StockBundle\Model\StockStyleQuery;

/**
 * @DI\Service("widget.stock_bundle.service.insert_stock_service")
 */
class InsertStockLogService
{
    /**
     * @param $id
     * @param $oldQuantity
     */
    public function insertLog($id, $oldQuantity, SiteUser $user)
    {
        $newStock = StockQuery::create()->findPk($id);
        $newQuantity = $newStock->getQuantity();
        $quantity = $newQuantity - $oldQuantity;
        $this->insertDb($id,$quantity, $oldQuantity, $user);
    }

    /**
     * @param integer $stockId 庫存ID
     * @param integer $quantity 異動數量
     * @param integer $oldQuantity 異動前數量
     * @param SiteUser $user
     */    
    protected function insertDb($stockId, $quantity, $oldQuantity, SiteUser $user)
    {
        $stockLog = new StockLog();
        $stockLog->setStockId($stockId);
        $stockLog->setSiteUserId($user->getId());
        //$stockLog->setQuantity($quantity);
        $stockLog->save();
        $stockLog->setOldQuantity($oldQuantity);
        $stockLog->setQuantity($quantity);
        $stockLog->save();
    }

    public function insertStyleLog($styleId, $oldQuantity, SiteUser $user)
    {
        $newStock = StockStyleQuery::create()->findPk($styleId);
        $newQuantity = $newStock->getQuantity();
        $quantity = $newQuantity - $oldQuantity;
        $this->insertStyleDb($styleId,$quantity, $oldQuantity, $user);
    }

    /**
     * @param integer $styleId 屬性庫存ID
     * @param integer $quantity 異動數量
     * @param integer $oldQuantity 異動前數量
     * @param SiteUser $user
     */
    protected function insertStyleDb($styleId, $quantity, $oldQuantity, SiteUser $user)
    {
        $stockLog = new StockStyleLog();
        $stockLog->setStyleId($styleId);
        $stockLog->setSiteUser($user);
        $stockLog->setOldQuantity($oldQuantity);
        $stockLog->setQuantity($quantity);
        $stockLog->save();
    }
}