module.exports =
{
  list:
#    id:
#      label: "#"
##      label: "index.stock.styld_id"
#      type: "id"
#      sort: true
#      search: true
#      searchConfig:
#        key: "id"
#        like: true
#        type: "text"
    product_id:
      label: "index.stock.product_id"
      type: "id"
      sort: true
      search: true
      searchConfig:
        key: "product_id"
        like: true
        type: "text"
    'product_name':
      label: "index.product.name"
      type: "text"
      search: false
      searchConfig:
        key: "product_name"
        like: true
        type: "text"
    'product_style_name':
      label: "index.stock.style"
      type: "text"
      search: false
      searchConfig:
        key: "product_style_name"
        like: true
        type: "text"
    quantity:
      label: "index.stock.quantity"
      type: "number"
      quick: true
    updated_at:
      label: "index.stock.updated_at"
      type: "datetime-local"
      defaultSorting: 'desc'
      sort: true
  extra: [
    {
      "roles": ["ROLE_PRODUCT_READ"]
      "component": require 'components/widgetstock/customize/list/batch.vue'
    }
    {
      "roles": ["ROLE_PRODUCT_READ"]
      "component": require 'components/widgetstock/customize/list/backToProduct.vue'
    }
  ]
  action: [
    {
      name: "view",
      label: "action.view",
      roles: ["ROLE_STOCK_READ", "ROLE_STOCK_WRITE"]
      route: 'stock_style-view'
    },
    {
      name: "quick"
      label: "action.quick"
      roles: ["ROLE_STOCK_WRITE"]
      component: require 'components/backendbase/partial/list/table/actions/quick.vue'
    }
  ]
}