<?php

namespace Widget\StockBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\ProductStyleBundle\Event\ProductStyleStockDeleteSingleEvent;
use Widget\StockBundle\Model\StockStyleQuery;

/**
 * @DI\Service()
 */
class ProductStyleStockDeleteSingleEventListener
{
    /**
     * @DI\Observe("event.product.style.delete.single.stock")
     */
    public function deleteSingleStyleStock(ProductStyleStockDeleteSingleEvent $event)
    {
        $event->stopPropagation();

        $styleStock = StockStyleQuery::create()->findPk($event->getId());
        if ($styleStock == null){
            return ;
        }
        
        $styleStock->getStockStyleLogs()->delete();
        $styleStock->delete();
    }
}