<?php

namespace Widget\StockBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\ProductStyleBundle\Event\ProductStyleStockDeleteEvent;
use Widget\StockBundle\Model\StockStyle;
use Widget\StockBundle\Model\StockStyleQuery;

/**
 * @DI\Service()
 */
class ProductStyleStockDeleteListener
{
    /**
     * @DI\Observe("event.product.style.delete.stock")
     */
    public function deleteStyleStock(ProductStyleStockDeleteEvent $event)
    {
        $event->stopPropagation();
        
        $styleStocks = StockStyleQuery::create()->filterByProductId($event->getProductId())->find();
        if ($styleStocks == null){
            return ;
        }
        /** @var StockStyle $styleStock */
        foreach ($styleStocks as $styleStock){
            $styleStock->getStockStyleLogs()->delete();
            $styleStock->delete();
        }
    }
}