<?php

namespace Widget\StockBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\ProductStyleBundle\Model\ProductStyleMix;
use Widget\StockBundle\Model\StockQuery;
use Widget\StockBundle\Model\StockStyleQuery;


/**
 * @DI\Service()
 */
class ProductAddEventListener
{
    const CHECK_STOCK = 'out of stock';
    /**
     * @DI\Observe(ProductAddEvent::EVENT_NAME, priority=-20)
     */
    public function checkStock(ProductAddEvent $event)
    {
        $stock = StockQuery::create()
            ->findPk($event->getId(), $event->getConnection());

        $stockStyle = StockStyleQuery::create()
            ->findPk($event->getId(), $event->getConnection());

        // 找不到庫存或有屬性庫存時就不做事
        if ($stock == null || $stockStyle != null){
            return;
        }
        if ($stock->getQuantity() >= $event->getCount()) {
            $newQuantity = $stock->getQuantity() - $event->getCount();
            $stock->setQuantity($newQuantity);
            $stock->save($event->getConnection());
        }
        else {
            $event->setError(self::CHECK_STOCK);
        }
    }
}