<?php

namespace Widget\StockBundle\Tests\Service;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\StockBundle\Model\StockLogQuery;
use Widget\StockBundle\Model\StockQuery;
use Widget\StockBundle\Service\InsertStockLogService;

class InsertStockLogServiceTest extends BaseWebTestCase
{
    public function test_insertLog()
    {
        // arrange
        $stock = StockQuery::create()->findOne();
        $stockId = $stock->getId();
        $quantity = 99;
        $oldQuantity = 100;
        $quantityLog = $quantity - $oldQuantity;
        $user = SiteUserQuery::create()->findOne();
        $stock->setQuantity($quantity)->save();
        $stock->setQuantity($oldQuantity);

        // act
        $insertStockLogService = $this->getMockBuilder(InsertStockLogService::class)
            ->disableOriginalConstructor()
            ->setMethods(array('insertDb'))
            ->getMock();
        $insertStockLogService
            ->expects($this->once())
            ->method('insertDb')
            ->willReturnCallback(function($stockIdForTest, $quantityForTest, $userForTest) use($stockId, $quantityLog, $user){
                $this->assertEquals($stockId, $stockIdForTest);
                $this->assertEquals($quantityLog, $quantityForTest);
                $this->assertEquals($userForTest, $user);
            });

        $insertStockLogService->insertLog($stock->getId(), $oldQuantity, $user);

        // assert

        // reset
        $stockBack = StockQuery::create()->findOne();
        $stockBack->setQuantity(100)->save();
    }

    public function test_insertDb()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $stock = StockQuery::create()->findOne();
        $stockId = $stock->getId();
        $user = SiteUserQuery::create()->findOne();
        $quantity = 5;

        // act
        $insertStockLogService = new InsertStockLogService();
        $this->callObjectMethod($insertStockLogService, 'insertDb', $stockId, $quantity, $user);

        // assert
        $stockLog = StockLogQuery::create()->filterByStockId($stockId)->findOne();
        $this->assertEquals($quantity, $stockLog->getQuantity());
        $this->assertEquals($user->getId(), $stockLog->getSiteUserId());

        $con->rollBack();

    }
}