<?php

namespace Widget\StockBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Event\ProductStyleStockDeleteSingleEvent;
use Widget\StockBundle\EventListener\ProductStyleStockDeleteSingleEventListener;
use Widget\StockBundle\Model\StockStyle;
use Widget\StockBundle\Model\StockStyleLog;
use Widget\StockBundle\Model\StockStyleQuery;

class ProductStyleStockDeleteSingleEventListenerTest extends BaseWebTestCase
{
    public function test_deleteSingleStyleStock()
    {
        // arrange
        $product = ProductQuery::create()->orderById(\Criteria::DESC)->findOne();
        $event = new ProductStyleStockDeleteSingleEvent($product->getId());

        // 寫幾筆假庫存&log進去
        $styleStock = new StockStyle();
        $styleStock->setId($product->getId());
        $styleStock->setProductId($product->getId());
        $styleStock->setQuantity(100);
        $styleStock->save();

        $styleStockLog = new StockStyleLog();
        $styleStockLog->setStockStyle($styleStock);
        $styleStockLog->setQuantity(999);
        $styleStockLog->save();

        // act
        $productStyleStockDeleteSingleEventListener = new ProductStyleStockDeleteSingleEventListener();
        $productStyleStockDeleteSingleEventListener->deleteSingleStyleStock($event);

        // assert
        $styleStock = StockStyleQuery::create()->findPk($product->getId());
        $this->assertNull($styleStock);
    }
}