<?php

namespace Widget\StockBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Event\ProductStyleStockCreateEvent;
use Widget\ProductStyleBundle\Model\ProductStyleMix;
use Widget\ProductStyleBundle\Model\ProductStyleQuery;
use Widget\StockBundle\EventListener\ProductStyleStockCreateListener;
use Widget\StockBundle\Model\StockStyleQuery;

class ProductStyleStockCreateListenerTest extends BaseWebTestCase
{
    public function test_createStock()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();
        $productId = ProductQuery::create()->orderById(\Criteria::DESC)->findOne()->getId();
        $styleArray = array();
        for ($i = 1; $i <= 3; $i++){
            $productStyleMix = new ProductStyleMix();
            $productStyleMix->setId(($i+1));
            $productStyleMix->setProductId($productId);
            $productStyleMix->setName(123);
            $productStyleMix->save();
            $styleArray[] = $productStyleMix;
        }

        $event = new ProductStyleStockCreateEvent($productId, $styleArray);
        $listener = new ProductStyleStockCreateListener();

        // act
        $listener->createStock($event);

        // assert
        /** @var ProductStyleMix $styleMix */
        foreach($styleArray as $styleMix){
            $stockQuery = StockStyleQuery::create()->findPk($styleMix->getId());
            $this->assertNotNull($stockQuery);
        }

        $con->rollBack();
    }
}
