<?php

namespace Widget\StockBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Model\ProductStyleQuery;
use Widget\StockBundle\EventListener\ProductStyleAddEventListener;
use Widget\StockBundle\Model\StockStyle;

class ProductStyleAddEventLListenerTest extends BaseWebTestCase
{
    public function test_checkStock_out_of_stock()
    {
        // arrange

        // 寫一筆庫存讓他查
        $productStyleId = ProductStyleQuery::create()->findOne()->getId();
        $stockStyle = new StockStyle();
        $stockStyle->setId($productStyleId);
        $stockStyle->setProductId(ProductQuery::create()->findOne()->getId());
        $stockStyle->setQuantity(10);
        $stockStyle->save();
        $count = 9999;

        $event = new ProductAddEvent($productStyleId, $count);
        $productStyleAddEventListener = new ProductStyleAddEventListener();

        // act
        $productStyleAddEventListener->checkStock($event);

        // assert
        $this->assertEquals(ProductStyleAddEventListener::CHECK_STOCK, $event->getError());

        // reset
        $stockStyle->delete();
    }

    public function test_checkStock()
    {
        // 寫一筆庫存讓他查
        $productStyleId = ProductStyleQuery::create()->findOne()->getId();
        $stockStyle = new StockStyle();
        $stockStyle->setId($productStyleId);
        $stockStyle->setProductId(ProductQuery::create()->findOne()->getId());
        $stockStyle->setQuantity(10);
        $stockStyle->save();
        $count = 5;

        $event = new ProductAddEvent($productStyleId, $count);
        $productStyleAddEventListener = new ProductStyleAddEventListener();

        // act
        $productStyleAddEventListener->checkStock($event);

        // assert
        $this->assertEquals(null, $event->getError());

        // reset
        $stockStyle->delete();
    }

}