<?php

namespace Widget\OrderBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\StockBundle\EventListener\ProductAddEventListener;
use Widget\StockBundle\Model\StockQuery;

class ProductAddEventListenerTest extends BaseWebTestCase
{
    private $productId;

    public function setUp()
    {
        parent::setUp();
        $this->productId = null;
    }

    protected function tearDown()
    {
        if($this->productId){
            StockQuery::create()
                ->findPk($this->productId)
                ->setQuantity(100)
                ->save();
        }
        parent::tearDown();
    }

    public function test_checkStock_ok()
    {
        // arrange
        $this->productId = 123456;
        $count = 10;
        $errorText = null;
        $listener = new ProductAddEventListener();
        $event = new ProductAddEvent($this->productId, $count);
        
        // act
        $listener->checkStock($event);
        
        // assert
        $this->assertEquals($errorText, $event->getError());
    }

    public function test_checkStock_error()
    {
        // arrange
        $this->productId = 123456;
        $count = 999999;
        $errorText = ProductAddEventListener::CHECK_STOCK;
        $listener = new ProductAddEventListener();
        $event = new ProductAddEvent($this->productId, $count);

        // act
        $listener->checkStock($event);

        // assert
        $this->assertEquals($errorText, $event->getError());
    }
}