<?php

namespace Widget\StockBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Model\ProductStyleMixQuery;
use Widget\StockBundle\Model\StockStyle;
use Widget\StockBundle\Model\StockStyleLogQuery;
use Widget\StockBundle\Model\StockStyleQuery;

class StockStyleControllerTest extends BackendWebTestCase
{
    public function test_searchAction()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $style = $this->createStockStyle();

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_stock_backendapi_stockstyle_search'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('id', $responseArray['data'][0]);
        $this->assertArrayHasKey('product_id', $responseArray['data'][0]);
        $this->assertArrayHasKey('quantity', $responseArray['data'][0]);

        $con->rollBack();
    }

    public function test_readAction()
    {
        // arrange
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        // 寫一筆讓他查
        $stockStyle = $this->createStockStyle();

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_stock_backendapi_stockstyle_read', array('id' => $stockStyle->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $stockStyle->delete();
        $this->assertTrue($response->isOk());
        $this->assertEquals($stockStyle->getId(), $responseArray['id']);
        $this->assertEquals($stockStyle->getQuantity(), $responseArray['quantity']);

        $con->rollBack();
    }

    public function test_updateAction()
    {
        $con = \Propel::getConnection();
        $con->beginTransaction();
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $params = array(
            'quantity' => 10
        );

        $stockStyle = $this->createStockStyle();
        $expertQuantityLog = 5;

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stockstyle_updatestock', array('id' => $stockStyle->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $stockStyleLog = StockStyleLogQuery::create()->filterByStyleId($stockStyle->getId())->orderById(\Criteria::DESC)->findOne();
        $this->assertTrue($response->isOk());
        $this->assertEquals($stockStyle->getId(), $responseArray['id']);
        $this->assertEquals($params['quantity'], $responseArray['quantity']);
        $this->assertEquals($expertQuantityLog, $stockStyleLog->getQuantity());

        $con->rollBack();
    }

    public function test_deleteAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stockStyle = $this->createStockStyle();

        // act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_stock_backendapi_stockstyle_delete', array('id' => $stockStyle->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        // assert
        $stockStyleQuery = StockStyleQuery::create()->findPk($stockStyle->getId());
        $this->assertTrue($response->isOk());
        $this->assertNull($stockStyleQuery);
    }

    protected function createStockStyle()
    {
        $stockStyle = new StockStyle();
        $stockStyle->setId(ProductStyleMixQuery::create()->findOne()->getId());
        $stockStyle->setProductId(ProductQuery::create()->findOne()->getId());
        $stockStyle->setQuantity(5);
        $stockStyle->save();
        return $stockStyle;
    }
}