<?php

namespace Widget\StockBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\StockBundle\Model\Stock;
use Widget\StockBundle\Model\StockLogQuery;
use Widget\StockBundle\Model\StockQuery;

class StockControllerTest extends BackendWebTestCase
{
    public function test_createAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $params = array(
            'id' => ProductQuery::create()->orderById(\Criteria::DESC)->findOne()->getId(),
            'quantity' => 10
        );
        // act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_stock_backendapi_stock_createstock'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $stock = StockQuery::create()->findPk($responseArray['id']);

        $this->assertTrue($response->isOk());
        $this->assertEquals($params['id'], $stock->getId());
        $this->assertEquals($params['quantity'], $stock->getQuantity());

        // reset
        $stock->delete();
    }


    public function test_searchAction()
    {
        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_stock_backendapi_stock_search'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('id', $responseArray['data'][0]);
        $this->assertArrayHasKey('quantity', $responseArray['data'][0]);

    }

    public function test_updateAction()
    {
        $con = \Propel::getConnection();
        $con->beginTransaction();

        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);
        $params = array(
            'quantity' => 10
        );

        $stock = StockQuery::create()->findPk(1);
        $expertQuantityLog = -90;

        // act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_stock_backendapi_stock_updatestock', array('id' => $stock->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $stockLog = StockLogQuery::create()->filterByStockId($stock->getId())->orderById(\Criteria::DESC)->findOne();
        $this->assertTrue($response->isOk());
        $this->assertEquals($stock->getId(), $responseArray['id']);
        $this->assertEquals($params['quantity'], $responseArray['quantity']);

        $this->assertEquals($expertQuantityLog, $stockLog->getQuantity());

        $con->rollBack();
    }

    public function test_deleteAction()
    {

        // arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $stock = new Stock();
        $stock->setProduct(ProductQuery::create()->orderById(\Criteria::DESC)->findOne());
        $stock->setQuantity(100);
        $stock->save();

        // act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_stock_backendapi_stock_delete', array('id' => $stock->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        // assert
        $stockQuery = StockQuery::create()->findPk($stock->getId());
        $this->assertTrue($response->isOk());
        $this->assertNull($stockQuery);
    }
}