module.exports =
{
  list:
    id:
      label: "#"
      type: "id"
      sort: true
      search: true
      searchConfig:
        key: "id"
        like: true
        type: "text"
    'product.name':
      label: "index.product.name"
      type: "text"
      sort: true
      search: true
      searchConfig:
        key: "product.name"
        like: true
        type: "text"
    quantity:
      label: "index.stock.quantity"
      type: "number"
      quick: true
    updated_at:
      label: "index.stock.updated_at"
      type: "datetime-local"
      sort: true
  extra: []
  action: [
    {
      name: "view",
      label: "action.view",
      roles: ["ROLE_STOCK_READ", "ROLE_STOCK_WRITE"]
      route: 'stock-view'
    },
    {
      name: "quick"
      label: "action.quick"
      roles: ["ROLE_STOCK_WRITE"]
      component: require 'components/backendbase/partial/list/table/actions/quick.vue'
    }
  ]
}