<?php
/**
 * Created by PhpStorm.
 * User: bubble
 * Date: 2016/7/13
 * Time: 下午 2:19
 */

namespace Widget\StockBundle\EventListener;
use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Model\OrderItem;
use Widget\PaymentBundle\Event\PaymentExpiredEvent;
use Widget\StockBundle\Model\StockQuery;
use Widget\StockBundle\Model\StockStyleQuery;


/**
 * @DI\Service()
 */
class StockRecoverListener
{
    /**
     * @DI\Observe("event.payment.expired")
     */
    public function onOrderInvaildEvent(PaymentExpiredEvent $event)
    {
        $con = $event->getCon();
        $order = $event->getOrder();
        foreach($order->getOrderItems(null, $con) as $orderItem){
            if($orderItem->getProductId() == null){
                continue;
            }
            $this->recoverStock($orderItem, $con);
        }
    }

    /**
     * @param $orderItem
     * @param $con
     * @throws \Exception
     * @throws \PropelException
     */
    protected function recoverStock(OrderItem $orderItem, $con)
    {
        $stock = StockQuery::create()->findPk($orderItem->getProductId(), $con);
        if ($stock != null){
            $stock
                ->setQuantity($orderItem->getQuantity() + $stock->getQuantity())
                ->save($con);
            return;
        }
        $stockStyle = StockStyleQuery::create()->findPk($orderItem->getProductId(), $con);
        if ($stockStyle != null){
            $stockStyle->setQuantity($orderItem->getQuantity() + $stockStyle->getQuantity());
        }

    }

}