<?php

namespace Widget\StockBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\ProductStyleBundle\Event\ProductStyleStockUpdateSingleEvent;
use Widget\StockBundle\Model\StockStyle;
use Widget\StockBundle\Model\StockStyleLog;
use Widget\StockBundle\Model\StockStyleLogQuery;
use Widget\StockBundle\Model\StockStyleQuery;

/**
 * @DI\Service()
 */
class ProductStyleStockUpdateSingleEventListener
{
    /**
     * @DI\Observe("event.product.style.update.single.stock")
     */
    public function updateStyleStock(ProductStyleStockUpdateSingleEvent $event)
    {
        $event->stopPropagation();

        // 撈出舊資料 並砍掉
        $oldStockStyleLog = StockStyleLogQuery::create()
            ->filterByStyleId($event->getOldId())
            ->find();
        $oldStockStyleLogArray = $oldStockStyleLog->toArray();

        $oldStockStyle = StockStyleQuery::create()
            ->filterById($event->getOldId())
            ->findOne();
        $oldStockStyleArray = array();
        if ($oldStockStyleLog){
            $oldStockStyleArray = $oldStockStyle->toArray();
        }

        
        $oldStockStyleLog->delete();
        $oldStockStyle->delete();

        // 建立新的寫入
        $stockStyle = new StockStyle();
        $stockStyle->fromArray($oldStockStyleArray);
        $stockStyle->setId($event->getId());
        $stockStyle->save();

        foreach ($oldStockStyleLogArray as $oldStockStyleLog){
            $styleLog = new StockStyleLog();
            $styleLog->setStockStyle($stockStyle);
            $styleLog->setSiteUserId($oldStockStyleLog['SiteUserId']);
            $styleLog->setQuantity($oldStockStyleLog['Quantity']);
            $styleLog->setCreatedAt($oldStockStyleLog['CreatedAt']);
            $styleLog->setUpdatedAt($oldStockStyleLog['UpdatedAt']);
            $styleLog->save();
        }

    }
}