<?php

namespace Widget\StockBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\ProductBundle\Model\ProductQuery;
use Widget\ProductStyleBundle\Event\ProductStyleStockMigrateEvent;
use Widget\StockBundle\Model\StockQuery;
use Widget\StockBundle\Model\StockStyle;

/**
 * @DI\Service()
 */
class ProductStyleStockMigrateListener
{
    /**
     * @DI\Observe("event.product.style.stock.migrate")
     */
    public function migrateStock(ProductStyleStockMigrateEvent $event)
    {
        $productStyleMixIds = $event->getProductStyleMixIds();
        $productIds = $event->getProductIds();
        foreach ($productStyleMixIds as $key => $productStyleMixId){
            $stockStyle = new StockStyle();
            $stockStyle->setId($productStyleMixId);
            $stockStyle->setProductId($productIds[$key]);
            $stock = StockQuery::create()->findPk($productIds[$key]);
            if ($stock != null){
                $stockStyle->setQuantity($stock->getQuantity());
            }
            else {
                $stockStyle->setQuantity(0);    
            }
            
            $stockStyle->save();
        }
    }
}