<?php

namespace Widget\StockBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\ProductStyleBundle\Event\ProductStyleStockCreateEvent;
use Widget\ProductStyleBundle\Model\ProductStyleMix;
use Widget\StockBundle\Model\StockStyle;

/**
 * @DI\Service()
 */
class ProductStyleStockCreateListener
{
    /**
     * @DI\Observe("event.product.style.create.stock")
     */
    public function createStock(ProductStyleStockCreateEvent $event)
    {
        /** @var ProductStyleMix $productStyleMix */
        foreach ($event->getProductMixArray() as $productStyleMix){
            $stock = new StockStyle();
            $stock->setId($productStyleMix->getId());
            $stock->setProductId($event->getProductId());
            $stock->setQuantity(0);
            $stock->save();
        }
    }
}