<?php

namespace Widget\StockBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\StockBundle\Model\StockStyleQuery;

/**
 * @DI\Service()
 */
class ProductStyleAddEventListener
{
    const CHECK_STOCK = 'out of stock';

    /**
     * @DI\Observe(ProductAddEvent::EVENT_NAME, priority=-10)
     */
    public function checkStock(ProductAddEvent $event)
    {
        $stockStyle = StockStyleQuery::create()
            ->findPk($event->getId(), $event->getConnection());

        if ($stockStyle == null){
            return;
        }

        if ($stockStyle->getQuantity() >= $event->getCount()) {
            $newQuantity = $stockStyle->getQuantity() - $event->getCount();
            $stockStyle->setQuantity($newQuantity);
            $stockStyle->save($event->getConnection());
        }
        else {
            $event->setError(self::CHECK_STOCK);
        }
    }
}