<?php
namespace Widget\StockBundle\EventListener;


use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Service;
use Widget\ProductBundle\Event\ProductModelJoinStockEvent;
use Widget\ProductStyleBundle\Model\ProductStyleMix;


/**
 * @Service()
 */
class ModelJoinStockListener
{
    /**
     * @DI\Observe(ProductModelJoinStockEvent::EVENT_NAME)
     */
    public function onProductModelJoinStock(ProductModelJoinStockEvent $event)
    {
        if (!$this->checkProductStyleBundle()){
            $event->getQuery()->joinWithStock();
        }
        else {
            
        }

    }

    /**
     * 確認有無安裝 ProductStyleBundle
     */
    protected function checkProductStyleBundle()
    {
        if(class_exists(ProductStyleMix::class)){
            return true;
        }
        else {
            return false;
        }
    }
}