<?php

namespace Widget\SMSBundle\Tests\Service;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Symfony\Component\Routing\Router;
use Widget\SMSBundle\Message\GeneralMessage;
use Widget\SMSBundle\Model\SmsLog;
use Widget\SMSBundle\Service\SMSTaiwanMobile;

class SMSTaiwanMobileTest extends BaseTestCase
{
    public function test_constant()
    {
        //arrange

        //act

        //assert
        $this->assertEquals('TaiwanMobile', SMSTaiwanMobile::PROVIDER_NAME);
    }

    public function test_send_invalidPhone()
    {
        //arrange
        $phonenumber = '0912415642';
        $content = 'this is test';
        $smsLog = new SmsLog();
        $sms = $this->getMockBuilder(SMSTaiwanMobile::class)
            ->setMethods(array(
                'initLog',
                'updateLog',
                'isValidPhoneNumber',
                'buildState',
                'doGet',
            ))
            ->getMock();
        $sms
            ->expects($this->once())
            ->method('initLog')
            ->with($phonenumber, $content)
            ->willReturn($smsLog);
        $sms
            ->expects($this->never())
            ->method('updateLog')
            ->with($smsLog);
        $sms
            ->expects($this->never())
            ->method('buildState');
        $sms
            ->expects($this->never())
            ->method('doGet');
        $sms
            ->expects($this->once())
            ->method('isValidPhoneNumber')
            ->with($phonenumber)
            ->willReturn(false);

        //act
        $result = $sms->send(new GeneralMessage($phonenumber, $content));

        //assert
        $this->assertFalse($result);
    }

    public function test_send_doGet_fail()
    {
        //arrange
        $phonenumber = '0912415642';
        $content = 'this is test';
        $state = 'test_state';
        $verify = 'test_verify';
        $callbackUrl = 'http://example.com/returl';
        $smsLog = new SmsLog();

        $config = array(
            'account' => 'dgfactor',
            'password' => '12345',
            'gateway' => 'http://example.com',
            'srcaddr' => '0912345678',
        );
        $router = $this->getMockBuilder(Router::class)
            ->setMethods(array('generate'))
            ->disableOriginalConstructor()
            ->getMock();

        $router
            ->expects($this->once())
            ->method('generate')
            ->with('widget_sms_front_taiwanmobile_response', array(
                'verify' => $verify,
                'state' => $state,
            ))
            ->willReturn($callbackUrl);

        $sms = $this->getMockBuilder(SMSTaiwanMobile::class)
            ->setMethods(array(
                'initLog',
                'updateLog',
                'isValidPhoneNumber',
                'buildState',
                'doGet',
                'generateVerify',
            ))
            ->getMock();
        $sms
            ->expects($this->once())
            ->method('initLog')
            ->with($phonenumber, $content)
            ->willReturn($smsLog);
        $sms
            ->expects($this->never())
            ->method('updateLog')
            ->with($smsLog);
        $sms
            ->expects($this->once())
            ->method('isValidPhoneNumber')
            ->with($phonenumber)
            ->willReturn(true);
        $sms
            ->expects($this->once())
            ->method('buildState')
            ->with($phonenumber)
            ->willReturn($state);
        $sms
            ->expects($this->once())
            ->method('doGet')
            ->with($config['gateway'], array(
                'username' => $config['account'],
                'password' => $config['password'],
                'dstaddr' => $phonenumber,
                'smbody' => $content,
                'response' => $callbackUrl,
                'rateplan' => 'A',
                'srcaddr' => '0912345678',
                'encoding' => 'BIG5',
            ))
            ->willReturn(false);
        $sms
            ->expects($this->once())
            ->method('generateVerify')
            ->with($state)
            ->willReturn($verify);

        $this->setObjectAttribute($sms, 'config', $config);
        $this->setObjectAttribute($sms, 'router', $router);

        //act
        $result = $sms->send(new GeneralMessage($phonenumber, $content));

        //assert
        $this->assertFalse($result);
    }

    public function test_send()
    {
        //arrange
        $phonenumber = '0912415642';
        $content = 'this is test';
        $state = 'test_state';
        $verify = 'test_verify';
        $response = "a=1\nb=2\nc=3\nmsgid=123";
        $callbackUrl = 'http://example.com/returl';
        $smsLog = new SmsLog();

        $config = array(
            'account' => 'dgfactor',
            'password' => '12345',
            'gateway' => 'http://example.com',
            'srcaddr' => '0912345678',
        );
        $router = $this->getMockBuilder(Router::class)
            ->setMethods(array('generate'))
            ->disableOriginalConstructor()
            ->getMock();

        $router
            ->expects($this->once())
            ->method('generate')
            ->with('widget_sms_front_taiwanmobile_response', array(
                'verify' => $verify,
                'state' => $state,
            ))
            ->willReturn($callbackUrl);

        $sms = $this->getMockBuilder(SMSTaiwanMobile::class)
            ->setMethods(array(
                'initLog',
                'updateLog',
                'isValidPhoneNumber',
                'buildState',
                'doGet',
                'generateVerify',
            ))
            ->getMock();
        $sms
            ->expects($this->once())
            ->method('initLog')
            ->with($phonenumber, $content)
            ->willReturn($smsLog);
        $sms
            ->expects($this->once())
            ->method('updateLog')
            ->with($smsLog);
        $sms
            ->expects($this->once())
            ->method('isValidPhoneNumber')
            ->with($phonenumber)
            ->willReturn(true);
        $sms
            ->expects($this->once())
            ->method('buildState')
            ->with($phonenumber)
            ->willReturn($state);
        $sms
            ->expects($this->once())
            ->method('doGet')
            ->with($config['gateway'], array(
                'username' => $config['account'],
                'password' => $config['password'],
                'dstaddr' => $phonenumber,
                'smbody' => $content,
                'response' => $callbackUrl,
                'rateplan' => 'A',
                'srcaddr' => '0912345678',
                'encoding' => 'BIG5',
            ))
            ->willReturn($response);
        $sms
            ->expects($this->once())
            ->method('generateVerify')
            ->with($state)
            ->willReturn($verify);

        $this->setObjectAttribute($sms, 'config', $config);
        $this->setObjectAttribute($sms, 'router', $router);

        //act
        $result = $sms->send(new GeneralMessage($phonenumber, $content));

        //assert
        $this->assertEquals('123', $result);
    }

    public function test_send_BIG5()
    {
        //arrange
        $phonenumber = '0912415642';
        $content = '中文测试故意加上残废字';
        $contentResult = '中文??故意加上??字';
        $state = 'test_state';
        $verify = 'test_verify';
        $response = "a=1\nb=2\nc=3\nmsgid=123";
        $callbackUrl = 'http://example.com/returl';
        $smsLog = new SmsLog();

        $config = array(
            'account' => 'dgfactor',
            'password' => '12345',
            'gateway' => 'http://example.com',
            'srcaddr' => '0912345678',
            'rateplan' => 'A',
            'srcaddr' => '0912345678',
            'encoding' => 'BIG5',
        );
        $router = $this->getMockBuilder(Router::class)
            ->setMethods(array('generate'))
            ->disableOriginalConstructor()
            ->getMock();

        $router
            ->expects($this->once())
            ->method('generate')
            ->with('widget_sms_front_taiwanmobile_response', array(
                'verify' => $verify,
                'state' => $state,
            ))
            ->willReturn($callbackUrl);

        $sms = $this->getMockBuilder(SMSTaiwanMobile::class)
            ->setMethods(array(
                'initLog',
                'updateLog',
                'isValidPhoneNumber',
                'buildState',
                'doGet',
                'generateVerify',
            ))
            ->getMock();
        $sms
            ->expects($this->once())
            ->method('initLog')
            ->with($phonenumber, $content)
            ->willReturn($smsLog);
        $sms
            ->expects($this->once())
            ->method('updateLog')
            ->with($smsLog);
        $sms
            ->expects($this->once())
            ->method('isValidPhoneNumber')
            ->with($phonenumber)
            ->willReturn(true);
        $sms
            ->expects($this->once())
            ->method('buildState')
            ->with($phonenumber)
            ->willReturn($state);
        $sms
            ->expects($this->once())
            ->method('doGet')
            ->with($config['gateway'], array(
                'username' => $config['account'],
                'password' => $config['password'],
                'dstaddr' => $phonenumber,
                'smbody' => iconv('UTF8', 'BIG5', $contentResult),
                'response' => $callbackUrl,
                'rateplan' => 'A',
                'srcaddr' => '0912345678',
                'encoding' => 'BIG5',
            ))
            ->willReturn($response);
        $sms
            ->expects($this->once())
            ->method('generateVerify')
            ->with($state)
            ->willReturn($verify);

        $this->setObjectAttribute($sms, 'config', $config);
        $this->setObjectAttribute($sms, 'router', $router);

        //act
        $result = $sms->send(new GeneralMessage($phonenumber, $content));

        //assert
        $this->assertEquals('123', $result);
    }
}