<?php
namespace Widget\SMSBundle\Tests\Service;


use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Symfony\Component\Routing\Router;
use Widget\SMSBundle\Service\AbstractSMS;

abstract class TestSMS extends AbstractSMS
{
    const PROVIDER_NAME = 'test';
}

class AbstractSMSTest extends BaseTestCase
{
    public function test_injectRouter()
    {
        //arrange
        $router = $this->getMockBuilder(Router::class)
            ->disableOriginalConstructor()
            ->getMock();
        $sms = $this->getMockBuilder(AbstractSMS::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        //act
        $sms->injectRouter($router);

        //assert
        $this->assertEquals($router, $this->getObjectAttribute($sms, 'router'));
    }

    public function test_injectConfig_empty_array()
    {
        //arrange
        $config = array();

        $sms = $this->getMockBuilder(TestSMS::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        //act
        $sms->injectConfig($config);

        //assert
        $this->assertEquals(array(), $this->getObjectAttribute($sms, 'config'));
    }

    public function test_injectConfig_config_key_not_exists()
    {
        //arrange
        $config = array(
            'bad' => array(0, 1, 2, 3)
        );

        $sms = $this->getMockBuilder(TestSMS::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        //act
        $sms->injectConfig($config);

        //assert
        $this->assertEquals(array(), $this->getObjectAttribute($sms, 'config'));
    }

    public function test_injectConfig()
    {
        //arrange
        $config = array(
            'test' => array(0, 1, 2, 3)
        );

        $sms = $this->getMockBuilder(TestSMS::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        //act
        $sms->injectConfig($config);

        //assert
        $this->assertEquals($config['test'], $this->getObjectAttribute($sms, 'config'));
    }

    public function test_isValidPhoneNumber_bad()
    {
        //arrange
        $phonenumber = '9249162';
        $sms = $this->getMockBuilder(AbstractSMS::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        //act
        $result = $this->callObjectMethod($sms, 'isValidPhoneNumber', $phonenumber);

        //assert
        $this->assertFalse($result);
    }

    public function test_isValidPhoneNumber()
    {
        //arrange
        $phonenumber = '0912345678';
        $sms = $this->getMockBuilder(AbstractSMS::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        //act
        $result = $this->callObjectMethod($sms, 'isValidPhoneNumber', $phonenumber);

        //assert
        $this->assertTrue($result);
    }

    public function test_buildState()
    {
        //arrange
        $phonenumber = '0912345678';
        $sms = $this->getMockBuilder(AbstractSMS::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        //act
        $result = $this->callObjectMethod($sms, 'buildState', $phonenumber);
        list($phone, $time) = explode('-', $result);

        //assert
        $this->assertEquals($phonenumber, $phone);
        $this->assertLessThanOrEqual(1, time() - $time);
    }

    public function test_generateVerify()
    {
        //arrange
        $state = '123456';
        $config = array(
            'test' => array(
                'account' => 'dgfactor',
                'password' => '12345',
            )
        );
        $sms = $this->getMockBuilder(AbstractSMS::class)
            ->setMethods(array())
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $this->setObjectAttribute($sms, 'config', $config['test']);

        //act
        $result = $sms->generateVerify($state);

        //assert
        $this->assertEquals(md5("dgfactor12345$state"), $result);
    }
}