<?php
namespace Widget\SMSBundle\Tests\Message;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\SMSBundle\Message\GeneralMessage;
use Widget\SMSBundle\Message\SMSMessageInterface;

class GeneralMessageTest extends BaseTestCase
{
    public function test_is_a_SMSMessageInterface()
    {
        //arrange
        //act
        $message = $this->getMockBuilder(GeneralMessage::class)
            ->disableOriginalConstructor()
            ->getMock();

        //assert
        $this->assertInstanceOf(SMSMessageInterface::class, $message);
    }

    public function test___construct()
    {
        //arrange
        $phone = 'testphone';
        $content = 'testmessage';

        //act
        $message = new GeneralMessage($phone, $content);

        //assert
        $this->assertEquals($phone, $this->getObjectAttribute($message, 'phone'));
        $this->assertEquals($content, $this->getObjectAttribute($message, 'content'));
        $this->assertEquals(null, $this->getObjectAttribute($message, 'sendAt'));
    }

    public function test___construct_with_sendAt()
    {
        //arrange
        $phone = 'testphone';
        $content = 'testmessage';
        $sendAt = new \DateTime();

        //act
        $message = new GeneralMessage($phone, $content, $sendAt);

        //assert
        $this->assertEquals($phone, $this->getObjectAttribute($message, 'phone'));
        $this->assertEquals($content, $this->getObjectAttribute($message, 'content'));
        $this->assertEquals($sendAt, $this->getObjectAttribute($message, 'sendAt'));
    }

    public function test_getPhone()
    {
        //arrange
        $phone = 'testphone';
        $message = $this->getMockBuilder(GeneralMessage::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($message, 'phone', $phone);

        //act
        $result = $message->getPhone();

        //assert
        $this->assertEquals($phone, $result);
    }

    public function test_getContent()
    {
        //arrange
        $content = 'testcontent';
        $message = $this->getMockBuilder(GeneralMessage::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($message, 'content', $content);

        //act
        $result = $message->getContent();

        //assert
        $this->assertEquals($content, $result);
    }

    public function test_getSendAt()
    {
        //arrange
        $sendAt = new \DateTime();
        $message = $this->getMockBuilder(GeneralMessage::class)
            ->setMethods()
            ->disableOriginalConstructor()
            ->getMock();
        $this->setObjectAttribute($message, 'sendAt', $sendAt);

        //act
        $result = $message->getSendAt();

        //assert
        $this->assertEquals($sendAt, $result);
    }
}