<?php

namespace Widget\OrderBundle\Tests\Controller\Front;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\SMSBundle\Event\SMSStatusUpdateEvent;
use Widget\SMSBundle\Model\SmsLog;
use Widget\SMSBundle\Model\SmsLogQuery;
use Widget\SMSBundle\Service\SMSKot;
use Widget\SMSBundle\Service\SMSTaiwanMobile;

class UpdateStateControllerTest extends BaseWebTestCase
{
    public function test_KotResponseAction_badVerify()
    {
        //arrange
        $state = 'test_state';
        $verify = 'test_verify';

        $sms = $this->getMockBuilder(SMSKot::class)
            ->disableOriginalConstructor()
            ->setMethods(array('generateVerify'))
            ->getMock();
        $sms
            ->expects($this->once())
            ->method('generateVerify')
            ->with($state)
            ->willReturn(null);
        $this->client->getContainer()->set('widget_sms.sms.kot', $sms);

        //act
        $this->client->request('GET', $this->generateUrl('widget_sms_front_kot_response', array(
            'verify' => $verify,
            'state' => $state,
        )));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isNotFound());
    }

    public function test_KotResponseAction()
    {
        //arrange
        $state = 'test_state';
        $verify = 'test_verify';
        $msgid = '1263162';
        $eventDispatched = false;

        $sms = $this->getMockBuilder(SMSKot::class)
            ->disableOriginalConstructor()
            ->setMethods(array('generateVerify'))
            ->getMock();
        $sms
            ->expects($this->once())
            ->method('generateVerify')
            ->with($state)
            ->willReturn($verify);
        $dispatcher = $this->client->getContainer()->get('event_dispatcher');
        $dispatcher->addListener(SMSStatusUpdateEvent::EVENT_NAME, function(SMSStatusUpdateEvent $event) use(&$eventDispatched, $msgid){
                $event->stopPropagation();
                $eventDispatched = true;
                $this->assertEquals($msgid, $event->getMsgid());
                $this->assertEquals(SMSKot::PROVIDER_NAME, $event->getProvider());
            }, 99999);
        $this->client->getContainer()->set('widget_sms.sms.kot', $sms);

        //act
        $this->client->request('GET', $this->generateUrl('widget_sms_front_kot_response', array(
            'verify' => $verify,
            'state' => $state,
            'kmsgid' => $msgid,
        )));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertTrue($eventDispatched);
        $this->assertEquals('ok', $response->getContent());
    }

    public function test_TwnResponseAction_badVerify()
    {
        //arrange
        $state = 'test_state';
        $verify = 'test_verify';

        $sms = $this->getMockBuilder(SMSKot::class)
            ->disableOriginalConstructor()
            ->setMethods(array('generateVerify'))
            ->getMock();
        $sms
            ->expects($this->once())
            ->method('generateVerify')
            ->with($state)
            ->willReturn(null);
        $this->client->getContainer()->set('widget_sms.sms.taiwanmobile', $sms);

        //act
        $this->client->request('GET', $this->generateUrl('widget_sms_front_taiwanmobile_response', array(
            'verify' => $verify,
            'state' => $state,
        )));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isNotFound());
    }

    public function test_TwnResponseAction()
    {
        //arrange
        $state = 'test_state';
        $verify = 'test_verify';
        $msgid = '1263162';
        $eventDispatched = false;

        $sms = $this->getMockBuilder(SMSTaiwanMobile::class)
            ->disableOriginalConstructor()
            ->setMethods(array('generateVerify'))
            ->getMock();
        $sms
            ->expects($this->once())
            ->method('generateVerify')
            ->with($state)
            ->willReturn($verify);
        $dispatcher = $this->client->getContainer()->get('event_dispatcher');
        $dispatcher->addListener(SMSStatusUpdateEvent::EVENT_NAME, function(SMSStatusUpdateEvent $event) use(&$eventDispatched, $msgid){
            $event->stopPropagation();
            $eventDispatched = true;
            $this->assertEquals($msgid, $event->getMsgid());
            $this->assertEquals(SMSTaiwanMobile::PROVIDER_NAME, $event->getProvider());
        }, 99999);
        $this->client->getContainer()->set('widget_sms.sms.taiwanmobile', $sms);

        //act
        $this->client->request('GET', $this->generateUrl('widget_sms_front_taiwanmobile_response', array(
            'verify' => $verify,
            'state' => $state,
            'msgid' => $msgid,
        )));
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
        $this->assertTrue($eventDispatched);
        $this->assertEquals("magicid=TWMrd_sms_gateway_rpack\nmsgid={$msgid}\n", $response->getContent());
    }
}