<?php

namespace Widget\SMSBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\SMSBundle\Message\SMSMessageInterface;

/**
 * @DI\Service("widget_sms.sms.taiwanmobile")
 */
class SMSTaiwanMobile extends AbstractSMS
{
    const PROVIDER_NAME = "TaiwanMobile";

    /**
     * 將curl的response字串轉成陣列型態
     * @param $response
     * @return array
     */
    protected function handleResponse($response)
    {
        $chr = chr(10);
        $response = explode($chr, $response);
        $response = array_filter($response);
        $responseArray = array();
        foreach ($response as $item) {
            $subItem = explode("=", $item);
            $responseArray[$subItem[0]] = $subItem[1];
        }
        return $responseArray;
    }

    public function send(SMSMessageInterface $message)
    {
        $smsLog = $this->initLog($message->getPhone(), $message->getContent());
        
        if(!$this->isValidPhoneNumber($message->getPhone())){
            return false;
        }

        $state = $this->buildState($message->getPhone());

        $params = array(
            'username' => $this->config['account'],
            'password' => $this->config['password'],
            'rateplan' => 'A',
            'srcaddr'  => $this->config['srcaddr'],
            'dstaddr'  => $message->getPhone(),
            'encoding' => 'BIG5',
            'smbody'   => iconv('utf8', 'big5//TRANSLIT//IGNORE', $message->getContent()),
            //'wapurl' => '',
            //'vldtime' => '',
            'response' => $this->router->generate('widget_sms_front_taiwanmobile_response', array('verify' => $this->generateVerify($state), 'state' => $state)),
        );

        if(($response = $this->doGet($this->config['gateway'], $params)) === false){
            return false;
        }

        $responseArray = $this->handleResponse($response);
        $smsLog->setMsgid($responseArray['msgid']);
        $this->updateLog($smsLog, $responseArray);
        return $responseArray['msgid'];
    }
}
