<?php
namespace Widget\SMSBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\SMSBundle\Message\SMSMessageInterface;

/**
 * @DI\Service("widget_sms.sms.kot")
 */
class SMSKot extends AbstractSMS
{
    const PROVIDER_NAME = 'Kot';

    public function send(SMSMessageInterface $message)
    {
        $smsLog = $this->initLog($message->getPhone(), $message->getContent());

        if(!$this->isValidPhoneNumber($message->getPhone())){
            return false;
        }

        $state = $this->buildState($message->getPhone());

        $params = array(
            'username' => $this->config['account'],
            'password' => $this->config['password'],
            'dstaddr' => $message->getPhone(),
            'smbody' => iconv('utf8', 'big5//TRANSLIT//IGNORE', $message->getContent()),
            'response' => $this->router->generate('widget_sms_front_kot_response', array('verify' => $this->generateVerify($state), 'state' => $state)),
        );

        if(($response = $this->doGet($this->config['gateway'], $params)) === false){
            return false;
        }

        parse_str($response, $result);

        $smsLog->setMsgid($result['kmsgid']);
        $this->updateLog($smsLog, $result);

        return $result['kmsgid'];
    }

}
