<?php

namespace Widget\SMSBundle\Service\Config;

use Backend\BaseBundle\Model\SiteQuery;
use Backend\BaseBundle\SiteConfig\SiteConfigBuilder;
use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Service;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * @Service("widget_sms.config.setup")
 */
class SetupService extends \ArrayObject
{

    /**
     * @DI\InjectParams({
     *    "siteConfigBuilder" = @DI\Inject("backend_base.site_config_builder"),
     * })
     */
    public function injectConfig(SiteConfigBuilder $siteConfigBuilder)
    {
        $this->exchangeArray((array) $siteConfigBuilder->build()->get('widget_sms'));
    }

}