<?php

namespace Widget\SMSBundle\Service;

use Backend\BaseBundle\Service\APIRequestTrait;
use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\Routing\Router;
use Widget\SMSBundle\Model\SmsLog;

abstract class AbstractSMS implements SMSInterface
{
    use APIRequestTrait;

    /** @var  Router */
    protected $router;
    protected $config;

    /**
     * @DI\InjectParams()
     */
    public function injectRouter(Router $router)
    {
        $this->router = $router;
    }

    /**
     * @DI\InjectParams({
     *     "config" = @DI\Inject("widget_sms.config"),
     * })
     */
    public function injectConfig($config)
    {
        $this->config = (isset($config[static::PROVIDER_NAME])?$config[static::PROVIDER_NAME]:array());
    }

    protected function isValidPhoneNumber($phone)
    {
        return preg_match('/^09\d{8}$/', $phone)?true:false;
    }

    protected function buildState($phone)
    {
        $time = time();
        return "$phone-$time";
    }

    public function generateVerify($state)
    {
        return md5($this->config['account'] . $this->config['password'] . $state);
    }

    /**
     * @param $phone
     * @param $content
     * @return SmsLog
     */
    public function initLog($phone, $content)
    {
        $smsLog = new SmsLog();
        $smsLog
            ->setProvider(static::PROVIDER_NAME)
            ->setDst($phone)
            ->setContent($content)
            ->save();
        return $smsLog;
    }

    public function updateLog(SmsLog $smsLog, $response)
    {
        $smsLog->appendLog($response);
    }

}
