<?php
namespace Widget\SMSBundle\EventListener;


use JMS\DiExtraBundle\Annotation as DI;
use Widget\SMSBundle\Event\SMSStatusUpdateEvent;
use Widget\SMSBundle\Model\SmsLogQuery;

/**
 * @DI\Service()
 */
class SMSStatusUpdateListener
{
    /**
     * @DI\Observe(SMSStatusUpdateEvent::EVENT_NAME)
     */
    public function onSMSStatusUpdate(SMSStatusUpdateEvent $event)
    {
        if(!($smsLog = SmsLogQuery::create()
            ->filterByMsgid($event->getMsgid())
            ->filterByProvider($event->getProvider())
            ->findOne())){
            return;
        }
        $smsLog->appendLog($event->getResponseMessage());
    }
}