<?php
namespace Widget\SMSBundle\Event;


use Symfony\Component\EventDispatcher\Event;

class SMSStatusUpdateEvent extends Event
{
    const EVENT_NAME = 'event.widget_sms.status.update';
    protected $provider;
    protected $msgid;
    protected $responseMessage;

    public function __construct($provider, $msgid, $responseMessage)
    {
        $this->provider = $provider;
        $this->msgid = $msgid;
        $this->responseMessage = $responseMessage;
    }

    /**
     * @return mixed
     */
    public function getMsgid()
    {
        return $this->msgid;
    }

    /**
     * @return mixed
     */
    public function getResponseMessage()
    {
        return $this->responseMessage;
    }

    /**
     * @return mixed
     */
    public function getProvider()
    {
        return $this->provider;
    }
}