<?php

namespace Widget\SMSBundle\Controller\Front;

use JMS\DiExtraBundle\Annotation as DI;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\SMSBundle\Event\SMSStatusUpdateEvent;

/**
 * @Route("/sms")
 */
class UpdateStateController extends Controller
{
    /**
     * @var EventDispatcherInterface
     * @DI\Inject()
     */
    protected $eventDispatcher;

    /**
     * @Route("/k/{verify}/{state}", name="widget_sms_front_kot_response")
     */
    public function KotResponseAction(Request $request, $verify, $state)
    {
        $sms = $this->get('widget_sms.sms.kot');

        if($sms->generateVerify($state) !== $verify){
            throw $this->createNotFoundException();
        }

       $params = $request->query->all();

        $this->eventDispatcher->dispatch(SMSStatusUpdateEvent::EVENT_NAME, new SMSStatusUpdateEvent($sms::PROVIDER_NAME, $params['kmsgid'], $params));
        return new Response('ok');
    }

    /**
     * @Route("/t/{verify}/{state}", name="widget_sms_front_taiwanmobile_response")
     */
    public function TwnResponseAction(Request $request, $verify, $state)
    {
        $sms = $this->get('widget_sms.sms.taiwanmobile');

        if($sms->generateVerify($state) !== $verify){
            throw $this->createNotFoundException();
        }

        $params = $request->query->all();
        $this->eventDispatcher->dispatch(SMSStatusUpdateEvent::EVENT_NAME, new SMSStatusUpdateEvent($sms::PROVIDER_NAME, $params['msgid'], $params));

        $responseText = "magicid=TWMrd_sms_gateway_rpack\nmsgid={$params['msgid']}\n";
        return new Response($responseText);
    }
}
