<?php
namespace Widget\ShipmentBundle\Tests\Discount;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;
use Widget\ShipmentBundle\Discount\AddShipment;

class AddShipmentTest extends BaseTestCase
{
    public function test_process_ok()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 200,
            ),
        );

        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1)
            ;
        $order->addProducts($orderItem);
        $chain = new AddShipment();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertTrue($chain->isProcessed());
        $this->assertCount(1, $order->getProducts());
        $this->assertCount(1, $order->getShipments());
        /** @var OrderItem $shipmentOrderItem */
        $shipmentOrderItem = $order->getShipments()[0];
        $this->assertEquals('運費', $shipmentOrderItem->getProductName());
        $this->assertEquals(200, $shipmentOrderItem->getUnitPrice());
        $this->assertEquals(1, $shipmentOrderItem->getQuantity());
    }

    public function test_process_no_Shipment_config()
    {
        //arrange
        $siteId = 12345;
        $config = array();

        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipment();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Shipment_shipment_enabled_config()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipment();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Shipment_shipment_enabled_false()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => false,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipment();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Shipment_zero_shipment()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 0,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipment();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }
}