<?php
namespace Widget\ShipmentBundle\Tests\Discount;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;
use Widget\ShipmentBundle\Discount\AddShipment;
use Widget\ShipmentBundle\Discount\AddShipmentDiscount;

class AddShipmentDiscountTest extends BaseTestCase
{
    public function test_process_ok()
    {
        //arrange
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 200,
            ),
            'Discount' => array(
                'discount_enabled' => true,
                'discount' => 50,
            ),
        );

        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1)
            ;
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertTrue($chain->isProcessed());
        $this->assertCount(1, $order->getProducts());
        $this->assertCount(1, $order->getDiscounts());
        /** @var OrderItem $shipmentOrderItem */
        $shipmentOrderItem = $order->getDiscounts()[0];
        $this->assertEquals('滿額免運費', $shipmentOrderItem->getProductName());
        $this->assertEquals(-200, $shipmentOrderItem->getUnitPrice());
        $this->assertEquals(1, $shipmentOrderItem->getQuantity());
    }

    public function test_process_low_price()
    {
        //arrange
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 200,
            ),
            'Discount' => array(
                'discount_enabled' => true,
                'discount' => 350,
            ),
        );

        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1)
        ;
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }


    public function test_process_no_Shipment_config()
    {
        //arrange
        $config = array(
            'Discount' => array(
                'discount_enabled' => true,
                'discount' => 50,
            ),
        );

        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Shipment_shipment_enabled_config()
    {
        //arrange
        $config = array(
            'Shipment' => array(),
            'Discount' => array(
                'discount_enabled' => true,
                'discount' => 50,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Shipment_shipment_enabled_false()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => false,
            ),
            'Discount' => array(
                'discount_enabled' => true,
                'discount' => 50,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Shipment_zero_shipment()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 0,
            ),
            'Discount' => array(
                'discount_enabled' => true,
                'discount' => 50,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Discount_config()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 200,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Discount_discount_enabled_config()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 200,
            ),
            'Discount' => array(

            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Discount_discount_enabled_false()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 200,
            ),
            'Discount' => array(
                'discount_enabled' => false,
                'discount' => 50,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_Discount_zero_discount()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 200,
            ),
            'Discount' => array(
                'discount_enabled' => true,
                'discount' => 0,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }

    public function test_process_no_Discount_discount()
    {
        //arrange
        $siteId = 12345;
        $config = array(
            'Shipment' => array(
                'shipment_enabled' => true,
                'shipment' => 200,
            ),
            'Discount' => array(
                'discount_enabled' => true,
            ),
        );


        $order = new Order();
        $orderItem = new OrderItem();
        $orderItem
            ->setUnitPrice(100)
            ->setQuantity(1)
            ->setProductName('test_product')
            ->setProductId(1);
        $order->addProducts($orderItem);

        $chain = new AddShipmentDiscount();
        $chain->injectConfig($config);

        //act
        $chain->process($order);

        //assert
        $this->assertFalse($chain->isProcessed());
    }
}