<?php
namespace Widget\ShipmentBundle\EventListener;

use Backend\BaseBundle\SiteConfig\SiteConfigBuilder;
use JMS\DiExtraBundle\Annotation as DI;
use Widget\OrderBundle\Event\DiscountChainEvent;
use Widget\ShipmentBundle\Discount\AddShipment;
use Widget\ShipmentBundle\Discount\AddShipmentDiscount;

/**
 * @DI\Service()
 */
class ShipmentDiscountListener
{
    /** @var  SiteConfigBuilder */
    protected $siteConfigBuilder;

    /**
     * @DI\InjectParams({
     *     "siteConfigBuilder" = @DI\Inject("backend_base.site_config_builder")
     * })
     */
    public function injectConfig(SiteConfigBuilder $siteConfigBuilder)
    {
        $this->siteConfigBuilder = $siteConfigBuilder;
    }

    /**
     * @DI\Observe(DiscountChainEvent::EVENT_NAME)
     */
    public function onConfigureDiscountChain(DiscountChainEvent $event)
    {
        $discountBuilder = $event->getDiscountBuilder();
        $config = $this->siteConfigBuilder->build($event->getSiteId())->get('widget_shipment');
        $discountBuilder
            ->add($this->createDiscount(AddShipment::class, $config, $event->getSiteId()))
        ;
    }

    protected function createDiscount($class, $config, $siteId)
    {
        return (new $class)->injectConfig($config)->injectSiteId($siteId);
    }
}