<?php
namespace Widget\ShipmentBundle\Tests\EventListener;

use Backend\BaseBundle\SiteConfig\SiteConfigBuilder;
use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\OrderBundle\Event\DiscountChainEvent;
use Widget\OrderBundle\Service\Discount\DiscountInterface;
use Widget\OrderBundle\Service\DiscountBuilder;
use Widget\ShipmentBundle\Discount\AbstractDiscount;
use Widget\ShipmentBundle\Discount\AddShipment;
use Widget\ShipmentBundle\Discount\AddShipmentDiscount;
use Widget\ShipmentBundle\EventListener\ShipmentDiscountListener;

class ShipmentDiscountListenerTest extends BaseTestCase
{
    public function test_onConfigureDiscountChain()
    {
        //arrange
        $config = array('test_config');
        $siteId = '12345';
        $classNames = array();

        $discount = $this->getMockBuilder(AbstractDiscount::class)
            ->disableOriginalConstructor()
            ->setMethods(array('setClassName'))
            ->getMockForAbstractClass();

        $discount
            ->expects($this->any())
            ->method('setClassName')
            ->willReturnCallback(function($className) use(&$classNames){
                $classNames[] = $className;
            });

        $discountBuilder = $this->getMockBuilder(DiscountBuilder::class)
            ->disableOriginalConstructor()
            ->setMethods(array('add'))
            ->getMock();

        $discountBuilder->expects($this->exactly(1))
            ->method('add')
            ->willReturnCallback(function(DiscountInterface $discount) use($discountBuilder){
                return $discountBuilder;
            });
        $event = new DiscountChainEvent($discountBuilder, $siteId);
        $configBuilder = $this->getMockBuilder(SiteConfigBuilder::class)
            ->disableOriginalConstructor()
            ->setMethods(array('build', 'get'))
            ->getMock();
        $configBuilder
            ->expects($this->once())
            ->method('build')
            ->willReturnCallback(function($siteIdForTest) use($configBuilder, $siteId){
                $this->assertEquals($siteId, $siteIdForTest);
                return $configBuilder;
            });
        $configBuilder
            ->expects($this->once())
            ->method('get')
            ->willReturnCallback(function($key) use($config){
                $this->assertEquals('widget_shipment', $key);
                return $config;
            });

        $listener = $this->getMockBuilder(ShipmentDiscountListener::class)
            ->disableOriginalConstructor()
            ->setMethods(array('createDiscount'))
            ->getMock();
        $listener
            ->expects($this->exactly(1))
            ->method('createDiscount')
            ->willReturnCallback(function($className, $configForTest, $siteIdForTest) use($discount, $config, $siteId){
                $this->assertEquals($config, $configForTest);
                $this->assertEquals($siteId, $siteIdForTest);
                $discount->setClassName($className);
                return $discount;
            });

        $listener->injectConfig($configBuilder);

        //act
        $listener->onConfigureDiscountChain($event);

        //assert
        $this->assertEquals(array(
            AddShipment::class,
        ), $classNames);
    }

    public function test_createDiscount()
    {
        //arrange
        $config = array('test_config');
        $siteId = 12345;

        $listener = new ShipmentDiscountListener();

        //act
        $result = $this->callObjectMethod($listener, 'createDiscount', AddShipment::class, $config, $siteId);

        //assert
        $this->assertInstanceOf(DiscountInterface::class, $result);
        $this->assertEquals($config, $this->getObjectAttribute($result, 'config'));
        $this->assertEquals($siteId, $this->getObjectAttribute($result, 'siteId'));
    }
}