<?php
namespace Widget\ShipmentBundle\EventListener\ControllerConfig;

use Backend\BaseBundle\Event\Controller;
use Backend\BaseBundle\Service\FunctionCheckerServiceInterface;
use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use Symfony\Component\Form\Extension\Core\Type as BaseType;
use Backend\BaseBundle\Form\Type\SubmitBackType;
use Backend\BaseBundle\Form\Type;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\GreaterThan;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Regex;

/**
 * @DI\Service()
 */
class SetupListener
{
    /** @var  FunctionCheckerServiceInterface */
    protected $functionChecker;

    /**
     * @InjectParams({
     *    "functionChecker" = @Inject("site.function.checker")
     * })
     */
    public function injectService(FunctionCheckerServiceInterface $functionChecker)
    {
        $this->functionChecker = $functionChecker;
    }

    /**
     * @DI\Observe(Controller\SetupEvent::EVENT_SETUP)
     */
    public function onSetup(Controller\SetupEvent $event)
    {
        if(!$this->functionChecker->isBundleEnabled('WidgetShipmentBundle')){
            return;
        }

        $event->setConfig('widget_shipment', array(
            'form' => array(
                array(
                    'Shipment',
                    new Type\BaseFormType(function(FormBuilderInterface $builder){
                        $builder
                            ->add('shipment_enabled', BaseType\ChoiceType::class, array(
                                'label' => 'form.label.setup.shipment.shipment.enabled',
                                'required' => false,
                                'multiple' => false,
                                'expanded' => true,
                                'choices' => array(
                                    true => 'form.choice.enable',
                                    false => 'form.choice.disable',
                                )
                            ))
                            ->add('shipment', BaseType\TextType::class, array(
                                'label' => 'form.label.setup.shipment.shipment.price',
                                'required' => false,
                                'constraints' => array(
                                    new Regex(array(
                                        'pattern' => '/^\d*$/'
                                    )),
                                    new GreaterThan(array(
                                        'value' => 0,
                                    ))
                                ),
                            ))
                        ;
                    }, 'Shipment'),
                    array(
                        'label' => 'form.label.setup.shipment.shipment.tab',
                        'attr' => array(
                            'data-subform' => 'tab',
                        ),
                    ),
                ),
                array(
                    'submit',
                    SubmitBackType::class,
                    array(
                        'with_back' => false,
                        'with_reset' => true,
                    ),
                ),
            ),
        ));
    }
}