<?php
namespace Widget\ShipmentBundle\Discount;

use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;

class AddShipment extends AbstractDiscount
{

    public function process(Order $order, \PropelPDO $con = null)
    {
        if(!isset($this->config['Shipment']) || !isset($this->config['Shipment']['shipment_enabled']) || !$this->config['Shipment']['shipment_enabled']){
            return;
        }

        if(!isset($this->config['Shipment']['shipment']) || $this->config['Shipment']['shipment'] == 0){
            return;
        }
        
        $this->processed = true;
        $item = new OrderItem();
        $item->setQuantity(1);
        $item->setProductName('運費');
        $item->setUnitPrice($this->config['Shipment']['shipment']);
        $order->addShipments($item);
         
    }
}