<?php

namespace Widget\ProductBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\OrderBundle\Event\ProductAddEvent;
use Widget\ProductBundle\EventListener\GetProductListener;
use Widget\ProductBundle\Model\ProductQuery;

class GetProductListenerTest extends BaseWebTestCase
{
    public function test_onGetProductInfo_not_found_product()
    {
        //arrange
        $productId = 123456789;
        $count = 10;
        $listener = new GetProductListener();
        $event = new ProductAddEvent($productId, $count);

        //act
        $listener->onGetProductInfo($event);

        //assert
        $this->assertTrue($event->isPropagationStopped());
    }

    public function test_onGetProductInfo_valid_product()
    {
        //arrange
        $product = ProductQuery::create()->orderById(\Criteria::DESC)->findOne();
        $count = 10;
        $listener = new GetProductListener();
        $event = new ProductAddEvent($product->getId(), $count);

        //act
        $listener->onGetProductInfo($event);

        //assert
        $this->assertEquals($product->getName(), $event->getProductName());
        $this->assertEquals($product->getPrice(), $event->getProductPrice());
    }
}