module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true
      "search": true
      searchConfig:
        key: "id"
        like: true
        type: "text"
    },
    "template_name": {
      "label": "index.styletemplate.name",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "template_name"
        like: true
        type: "text"
    }
    "created_at": {
      "label": "index.styletemplate.created_at",
      "type": "datetime-local",
      "sort": true
    }
    "updated_at": {
      "label": "index.styletemplate.updated_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    }
  },
  "extra": [
    {
      "name": "new"
      "label": "form.button.new"
      "roles": ["ROLE_PRODUCT_WRITE"]
      "route": 'styletemplate-new'
    }
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_PRODUCT_WRITE"]
      "route": 'styletemplate-edit'
    }
    {
      "name": "delete"
      "label": "action.delete"
      "roles": ["ROLE_PRODUCT_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}