faker = require 'faker'
faker.locale = 'en'
module.exports = (api) ->
  api.style =
    read: (id) ->
      new Promise (resolve, reject) ->
        data =
          id: 0
        resolve data

    # 套用樣板, /style/:id
    create: (product_id, ids, default_style, customize) ->
      params =
        product_id: product_id
        template_ids: ids
        default_style: default_style
        toAdd: customize.toAdd
        toDelete: customize.toDelete
      api.request  "POST", "/productstyles", params

    # 完全自訂
    allCustomize: (params) ->
      api.request  "POST", "/productstyle/withouttemplate", params

    # 新增自訂屬性, /style/:id
    addStyle: (product_id, params) ->
      api.request  "PUT", "/productstyle/#{product_id}", params

    # 更新單一屬性, /style/:id
    updateSingleStyle: (styleId, params) ->
      api.request  "PUT", "/productstyle/single/#{styleId}", params

    # 刪除單一屬性, /style/:id
    deleteSingleStyle: (styleId, params) ->
      api.request  "DELETE", "/productstyle/single/#{styleId}", params

    # 取得全部的樣板
    getTemplate: () ->
      api.request "GET", "/producttemples/all"

    # 取得該template的組合
    query: (ids) ->
      data =
        template_ids: ids
      api.request "POST", "/productstyle/query", data

    # 取得商品資訊(檢查是否已套用屬性, 該商品所有屬性組合)
    getProduct: (id) ->
      api.request  "GET", "/product/#{id}"

    resetAllStyle: (id) ->
      api.request "DELETE", "/productstyle/#{id}"