faker = require 'faker'
faker.locale = 'en'
bundleconfig = require 'components/backendbase/config/env/allBundle.json'
module.exports = (api) ->
  api.product =
    search: (data) ->
      api.request "GET", "/products", data
    create: (data) ->
      api.request "POST", "/products", data
    read: (id) ->
      api.request  "GET", "/product/#{id}"
    update: (id, data) ->
      api.request  "PUT", "/product/#{id}", data
#    delete: (id) ->
#      api.request  "DELETE", "/product/#{id}"
    batch: (ids, action, column, value) ->
      api.request  "PUT", "/products",
        ids: ids
        value: value
        action: action
        column: column
    getCategories:() ->
      api.request "GET", "/productcategorys/all"
    categoryproduct:(id, data) ->
      api.request "POST", "/product/#{id}/categoryproduct", data
    # 檢查有無安裝庫存 bundle
    checkStock: () ->
      api.request "GET", "/product/check/stockbundle"
    createStock: (data) ->
      api.request "POST", "/stocks", data
    updateStock: (id, data) ->
      api.request "PUT", "/stock/#{id}", data

    # 是否使用規格屬性, 產品表單庫存設定動態產生用
    useStyle: () ->
      new Promise (resolve, reject) ->
        resolve bundleconfig.WidgetProductStyleBundle != undefined

    deleteStyle: (id) ->
      api.request "DELETE", "/productstyle/#{id}"