<?php
namespace Widget\ProductBundle\EventListener\Serializer;

use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\Tag;
use JMS\Serializer\EventDispatcher\ObjectEvent;
use JMS\Serializer\EventDispatcher\PreSerializeEvent;
use Widget\PostBundle\Form\Transformer\PostPhotoTransformer;
use Widget\ProductBundle\Model\Product;

/**
 * @Service
 * @Tag("jms_serializer.event_listener", attributes = {"public": false, "event": "serializer.pre_serialize", "method": "onProductSerialize"})
 */
class ProductSerializerListener
{
    /** @var PostPhotoTransformer  */
    protected $transformer;

    /**
     * @InjectParams({
     *     "transformer" = @Inject("widget_post.post_photo_transformer"),
     * })
     */
    public function injectTransformer(PostPhotoTransformer $transformer)
    {
        $this->transformer = $transformer;
    }

    public function onProductSerialize(PreSerializeEvent $event)
    {
        $object = $event->getObject();
        if(!($object instanceof Product)){
            return;
        }

//        $object->setTransformedContent($this->transformer->transform($object->getContent()));
    }
}