<?php
namespace Widget\ProductBundle\Tests\InitDatabase;

use Backend\BaseBundle\Event\TestInitEvent;
use Backend\BaseBundle\Model;
use JMS\DiExtraBundle\Annotation\Observe;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\InjectParams;
use JMS\DiExtraBundle\Annotation\Service;
use Symfony\Component\HttpFoundation\File\File;
use Widget\CategoryBundle\Model\Category;
use Widget\CategoryBundle\Model\CategoryQuery;
use Widget\PhotoBundle\File\PhotoUploadFile;
use Widget\PhotoBundle\Image\PhotoConfigFinder;
use Widget\PhotoBundle\Image\Resizer;
use Widget\ProductBundle\Model\Product;

/**
 * @Service
 */
class initProduct
{

    /** @var  \Faker\Generator */
    protected $faker;

    /** @var  Resizer */
    protected $resizer;

    /** @var  PhotoConfigFinder */
    protected $configFinder;

    /**
     * @InjectParams({
     *     "faker" = @Inject("faker.generator", required = false),
     * })
     */
    public function injectFaker(\Faker\Generator $faker)
    {
        $this->faker = $faker;
    }

    /**
     * @InjectParams({
     *     "resizer" = @Inject("widget_photo.image.resizer"),
     * })
     */
    public function injectResizer(Resizer $resizer)
    {
        $this->resizer = $resizer;
    }

    /**
     * @InjectParams({
     *     "configFinder" = @Inject("widget.photo_bundle.config_finder"),
     * })
     */
    public function injectConfigFinder(PhotoConfigFinder $configFinder)
    {
        $this->configFinder = $configFinder;
    }

    /**
     * @Observe(TestInitEvent::EVENT_TEST_INIT, priority = 90)
     */
    public function onInit(TestInitEvent $event)
    {
        $rootCategory = CategoryQuery::create()
            ->filterByTreeLevel(0)
            ->useCategoryThreadQuery()
                ->filterByThread('product')
            ->endUse()
            ->findOne();
        $event->getOutput()->writeln("<info>Create Product</info>");
        $this->initCategories($rootCategory);
        $event->getOutput()->writeln("<comment>30</comment> <info>Categories created</info>");
    }

    protected function initCategories(Category $rootCategory)
    {
        $children = $rootCategory->getChildren(CategoryQuery::create()->filterByStatus(true));
        foreach ($children as $childCategory){
            $this->initCategoryProduct($childCategory);
        }
    }

    protected function initCategoryProduct(Category $category)
    {
        for ($i=0;$i<3;$i++){
            $this->appendProduct($category);
        }
    }

    protected function appendProduct(Category $category)
    {
        $price = rand(1000, 9999);
        $product = new Product();
        /** @var Product $product */
        $product
            ->setName($this->faker->text(10))
            ->setCode($this->faker->text(10))
            ->setOriginPrice(floor($price * 1.1))
            ->setPrice($price)
            ->setContent($this->faker->text(20));
        $this->attachPhoto($product);
        $product->save();
        $category->addProduct($product);
        $category->save();
    }

    protected function attachPhoto(Product $product)
    {
        $photoFile = new File($this->fakePhoto(1024, 768));

        $uploadPhoto = PhotoUploadFile::createFromUploadFile(
            $photoFile,
            $this->resizer,
            $this->configFinder->findConfig('photos')
        );
        $photo = $uploadPhoto->makePhoto();
        $photo->save();
        $product->setPhotos(array($photo));
    }

    protected function fakePhoto($width, $height)
    {
        //return $this->faker->image(sys_get_temp_dir(), $width, $height);
        return __DIR__.'/../Fixture/sports.jpg';
    }
}
