<?php
namespace Widget\ProductBundle\Tests\Controller\BackendAPI;


use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\ProductBundle\Model\Product;
use Widget\ProductBundle\Model\ProductQuery;

class ProductControllerTest extends BackendWebTestCase
{
    public function test_createAction_success()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $params = array(
            'name' => '迪士尼系列商品',
            'origin_price' => '1900',
            'price' => '1500',
            'brief' => '米其；米泥',
            'code' => 'MickyMouse',
            'content' => '米期帶著高非去跟米尼約會',
            'status_shelf' => '50'
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_product_backendapi_product_create', array()),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );

        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);
        $product = ProductQuery::create()
            ->findOneById($result['id']);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $product->getName());
        $this->assertEquals($params['price'], $product->getPrice());

        //reset
        $product->delete();
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $params = array(
            'name' => '海免包包',
            'price' => '20000'
        );

        $product = ProductQuery::create()->findOneById('123456');
        $originProductArray = $product->toArray();

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_product_backendapi_product_update', array('id' => $product->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $product->reload(true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $product->getName());
        $this->assertEquals($params['price'], $product->getPrice());

        //reset
        $product->fromArray($originProductArray, \BasePeer::TYPE_FIELDNAME);
        $product->save();
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);
        $params = array(
            'page' => 1,
            'sort' => array(
                'id' => 'asc'
            ),
            'search' => array(
                'id' => '123456',
            ),
        );
        $resultKeys = array(
            'id',
            'name',
            'code',
            'status_shelf',
            'origin_price',
            'price',
            'feature',
            'brief',
            'stock',
            'created_at',
            'updated_at'
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_product_backendapi_product_search', $params),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals(1, $result['pager']['page']);
        $this->assertEquals(1, $result['pager']['pages']);
        $this->assertEquals(1, $result['pager']['rows']);
        $this->assertEquals(1, count($result['data']));
        foreach($resultKeys as $key) {
            $this->assertArrayHasKey($key, $result['data'][0]);
        }
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $user = SiteUserQuery::create()->findOneByLoginName($loginName);
        $token = $this->createToken($user, $origin);

        $product = ProductQuery::create()->findOne();

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_product_backendapi_product_read', array('id'=>$product->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());

        //reset
    }
}