module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        like: true
        type: "text"
    },
    "name": {
      "label": "index.product.name",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "name"
        like: true
        type: "text"
    },
    "price": {
      "label": "index.product.price",
      "type": "number",
      "quick": true,
    },
    "code": {
      "label": "index.product.code",
      "type": "text",
      "sort": true,
      "search": true
      searchConfig:
        key: "code"
        like: true
        type: "text"
    },
    "status_shelf": {
      "label": "index.product.status_shelf",
      "type": "checkbox",
      "quick": true,
      "search": true
      "batch": true
      batchSetting: [
        { label: 'index.product.on_shelf', value: true }
        { label: 'index.product.off_shelf', value: false }
      ]
      defaultFilter: true
      searchConfig:
        key: "status_shelf"
        type: "radio"
    },
    "photos": {
      "label": "index.product.photos",
      "type": "image"
    },
    "created_at": {
      "label": "index.product.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    }
  },
  "extra": [
    {
      "name": "new"
      "label": "form.button.new"
      "roles": ["ROLE_PRODUCT_WRITE"]
      "route": 'product-new'
    }
    {
      "name": "quick_search",
      "label": "action.quick",
      "roles": ["ROLE_PRODUCT_WRITE"]
      component: require 'components/backendbase/partial/list/extra/quicksearch.vue'
      config:
        key: 'status_shelf'
        apiName: 'product'
        status: [
          { label: 'index.product.quick_search.all', value: 'all' }
          { label: 'index.product.quick_search.on_shelf', value: true }
          { label: 'index.product.quick_search.off_shelf', value: false }
        ]
    }
  ],
  "action": [
    {
      "roles": ["ROLE_PRODUCT_WRITE"]
      "component": require 'components/widgetproduct/customize/list/actions/style.vue'
    }
    {
      "roles": ["ROLE_PRODUCT_WRITE"]
      "component": require 'components/widgetproduct/customize/list/actions/style_delete.vue'
    }
    {
      "roles": ["ROLE_PRODUCT_STOCK"]
      "component": require 'components/widgetproduct/customize/list/actions/stock.vue'
    }
    {
      "roles": ["ROLE_PRODUCT_STOCK"]
      "component": require 'components/widgetproduct/customize/list/actions/stock_style.vue'
    }
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_PRODUCT_WRITE"]
      "route": 'product-edit'
    }
    {
      "name": "quick",
      "label": "action.quick",
      "roles": ["ROLE_PRODUCT_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/quick.vue'
    }
  ]
}