module.exports =
[
  {
    "name": "name",
    "text": "index.product.name",
    "required": true,
    "type": "input"
  },
  {
    "name": "code",
    "text": "index.product.code",
    "type": "input"
  },
  {
    "name": "origin_price",
    "text": "index.product.origin_price",
    "required": true,
    "type": "input"
  },
  {
    "name": "price",
    "text": "index.product.price",
    "required": true,
    "type": "input"
  },
  {
    "name": "feature",
    "text": "index.product.feature",
    "type": "input",
    "config":{
      "help": "form.help.feature.name"
    }
  },
  {
    "name": "brief",
    "text": "index.product.brief",
    "required": true,
    "type": "textarea"
  },
  {
    "name": "content",
    "text": "index.product.content",
    "type": "html"
  },
  {
    "name": "status_shelf",
    "text": "index.product.status_shelf",
    "type": "switch",
    "config":{
      on: 'form.choice.enable'
      off: 'form.choice.disable'
    }
  },
  {
    "name": "categories",
    "text": "index.product.groups",
    "type": "selector",
    "config":
      api: "product.getCategories"
      removeRoot: true
  },
  {
    "name": "photos",
    "text": "index.product.photos",
    "type": "photos",
    required: true
    "config": {
      "max": 5,
      "min": 1,
      "configType": "product"
    }
  }
  {
    name: 'stock'
    text: 'stock'
    type: 'customize'
    component: require "components/widgetproduct/customize/edit/stock.vue"
    config:
      dynamicCreated: true
      api: 'product.useStyle'
  }
]