<?php

namespace Widget\ProductBundle\Model;

use Widget\ProductBundle\Model\om\BaseProduct;
use Widget\ProductStyleBundle\Model\ProductStyle;
use Widget\ProductStyleBundle\Model\ProductStyleMix;
use Widget\StockBundle\Model\Stock;

class Product extends BaseProduct
{
    public function getStock(\PropelPDO $con = null)
    {
        if(class_exists(Stock::class) && !class_exists(ProductStyleMix::class)){
            return parent::getStock($con);
        }
        return null;
    }

    public function getStyleStatus(\PropelPDO $con = null)
    {
        if (!class_exists(ProductStyleMix::class)){
            return null;
        }
        /** @var ProductStyleMix $productStyleMix */
        if (parent::getProductStyleMixes($con)->count() >= 1){
            return true;
        }
        return false;
    }

    /**
     * 取得屬性
     * @param \PropelPDO|null $con
     * @return null|\PropelObjectCollection|\Widget\ProductStyleBundle\Model\ProductToStyleConfig[]
     */
    public function getStyles(\PropelPDO $con = null)
    {
        if (!class_exists(ProductStyleMix::class)){
            return null;
        }
        return $this->getProductToStyleConfigs(null, $con);
    }

    /**
     * 取得屬性組合
     */
    public function getStockStyle(\PropelPDO $con = null)
    {
        if (!class_exists(ProductStyleMix::class)){
            return null;
        }
        return $this->getProductStyleMixes(null, $con);
    }
}
